/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.relics;

import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.PotionHelper;
import com.megacrit.cardcrawl.relics.AbstractRelic;

public class TinyHouse
extends AbstractRelic {
    public static final String ID = "Tiny House";
    private static final int GOLD_AMT = 30;
    private static final int HP_AMT = 5;

    public TinyHouse() {
        super(ID, "tinyHouse.png", AbstractRelic.RelicTier.BOSS, AbstractRelic.LandingSound.FLAT);
    }

    @Override
    public String getUpdatedDescription() {
        return this.DESCRIPTIONS[0] + 30 + this.DESCRIPTIONS[1] + 5 + this.DESCRIPTIONS[2];
    }

    @Override
    public void onEquip() {
        AbstractDungeon.player.increaseMaxHp(5, true);
        AbstractDungeon.getCurrRoom().addGoldToRewards(30);
        AbstractDungeon.getCurrRoom().addPotionToRewards(PotionHelper.getRandomPotion(AbstractDungeon.miscRng));
        AbstractDungeon.combatRewardScreen.open(this.DESCRIPTIONS[3]);
        AbstractDungeon.getCurrRoom().rewardPopOutTimer = 0.0f;
    }

    @Override
    public AbstractRelic makeCopy() {
        return new TinyHouse();
    }
}

